local songName= GAMESTATE:GetCurrentSong():GetSongDir()

local tileObjects = {}

P1 = nil;
P2 = nil;

local hstrips = 30
local vstrips = 10

local sw = SCREEN_WIDTH
local sh = SCREEN_HEIGHT
local tiles = {}
local tiles2d = {}

local tskm = 0.225;

local function mod_internal(str, pn)
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function mod(str)
	for i=1,2 do
		mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function get_speed_from_poptions(player_number)
	if GAMESTATE:IsPlayerEnabled(player_number) then
		local poptionsray= GAMESTATE:GetPlayerState(player_number):GetPlayerOptionsArray("ModsLevel_Song")
		local speed= nil
		local mode= nil
		for i, el in ipairs(poptionsray) do
			local fel= el:sub(1, 1)
			local lel= el:sub(-1)
			if fel == "m" or fel == "C" then
				speed= tonumber(el:sub(2))
				mode= fel
			elseif lel == "x" then
				speed= tonumber(el:sub(1, -2))
				mode= lel
			end
			if speed and mode then
				break
			end
		end
	end
	if not speed or not mode then
		speed= 2
		mode= "x"
	end
	return { speed= speed, mode= mode }
end

local function set_player_speed(player_number, speed_info)
	if not GAMESTATE:IsPlayerEnabled(player_number) then return end
	local mode_functions= {
		x= function(speed)
				 mod_internal(("*1000 %.2f"):format(speed).."x", player_number)
			 end,
		C= function(speed)
				 mod_internal("*1000 C"..("%.0f"):format(speed), player_number)
			 end,
		m= function(speed)
				 local max_bpm= GAMESTATE:GetCurrentSteps(pn):GetDisplayBpms()[2]
				 local real_speed= (speed / max_bpm)
				 -- Setting an mmod while on ScreenGameplay doesn't actually work, due to the way mmods are implemented in the engine. So set the equivalent xmod
				 mod_internal(("*1000 %.2f"):format(real_speed).."x", player_number)
			 end
	}
	mode_functions[speed_info.mode](speed_info.speed)
end

function simple_m0d(beat,strength,mult,mod,pn)
	if not strength then strength = 400 end
	if not mult then mult = 1 end
	if not mod then mod = 'drunk' end
	
	local alive = math.max(2*mult*math.abs(strength)/100,0.25)
	
	table.insert(mods,{beat,'*100000 '..strength..' '..mod,pn});
	table.insert(mods,{beat+.1,'*'..((1/mult)*math.abs(strength)/100)..' no '..mod,pn});
end
			
--alternates a mod back and forth before resetting to 0
--beat,num,div,amt,mod,pn
function mod_wiggle(beat,num,div,amt,mod,pn,first)
	local fluct = 1
	for i=0,(num-1) do
		b = beat+(i/div)
		local m = 1
		if i==0 and not first then m = 0.5 end
		table.insert(mods,{b,'*'..math.abs(m*amt/10)..' '..(amt*fluct)..' '..mod..'',pn});
		fluct = fluct*-1;
	end
	table.insert(mods,{beat+(num/div),'*'..math.abs(amt/20)..' no '..mod..'',pn});
end

local function init()
	checked = false;
	
	diffP1 = -1;
	diffP2 = -1;
	
	if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
		diffP1 = Difficulty:Reverse()[GAMESTATE:GetCurrentSteps(PLAYER_1):GetDifficulty()]
	end
	if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
		diffP2 = Difficulty:Reverse()[GAMESTATE:GetCurrentSteps(PLAYER_2):GetDifficulty()]
	end
	
	speedmodP1 = get_speed_from_poptions(PLAYER_1)
	speedmodP2 = get_speed_from_poptions(PLAYER_2)
	
	fgcurcommand = 1;
	checked = false;
	
	finalEvent = false;
			
	mod_firstSeenBeat = GAMESTATE:GetSongBeat()
			
--how can I make simple m0d?
--this will instantly turn a mod on to max and then quickly turn it off with the specified parameters
--it's a simple mod

function simple_m0d(beat,strength,mult,mod,pn)
	if not strength then strength = 400 end
	if not mult then mult = 1 end
	if not mod then mod = 'drunk' end
	
	local alive = math.max(2*mult*math.abs(strength)/100,0.25)
	
	table.insert(mods,{beat,'*100000 '..strength..' '..mod,pn});
	table.insert(mods,{beat+.1,'*'..((1/mult)*math.abs(strength)/100)..' no '..mod,pn});
end
			
--alternates a mod back and forth before resetting to 0
--beat,num,div,amt,mod,pn
function mod_wiggle(beat,num,div,amt,mod,pn,first)
	local fluct = 1
	for i=0,(num-1) do
		b = beat+(i/div)
		local m = 1
		if i==0 and not first then m = 0.5 end
		table.insert(mods,{b,'*'..math.abs(m*amt/10)..' '..(amt*fluct)..' '..mod..'',pn});
		fluct = fluct*-1;
	end
	table.insert(mods,{beat+(num/div),'*'..math.abs(amt/20)..' no '..mod..'',pn});
end
			
--lua course :D
curmod = 1;
--{beat,mod,player}
mods = {

--Start.
{0, '*99 2.25x,*99 overhead,*99 no reverse,*99 no mini,*99 65% cover'},
{32, '*0.45 50% flip,*0.45 50% reverse'},
{40, 'no flip,no reverse'},
{48, '*0.45 50% flip,*0.45 50% reverse'},
{56, 'no flip,no reverse'},
{64, '*0.45 50% flip,*0.45 50% reverse,tipsy'},
{72, 'no flip,no reverse'},
{80, '*0.45 50% flip,*0.45 50% reverse'},
{88, 'no flip,no reverse'},
{94, 'tornado,55 stealth,*99 2000% dizzy'},
{96, '*99 9000% beat,*99 no tornado,*99 no stealth,*1000 no dizzy,*99 no tipsy'},
{96.25, '*9999 no beat'},
{98, '*99 -9000% beat'},
{98.25, '*9999 no beat'},
{100, '*4 invert'},
{100.5, '*4 no invert'},
{101, '*4 invert'},
{101.5, '*4 no invert'},
{102, '*99 9000% beat'},
{102.25, '*9999 no beat'},
{104, '*4 invert'},
{104.5, '*4 no invert'},
{105, '*4 invert'},
{105.5, '*4 no invert'},
{106, '*99 -9000% beat'},
{106.25, '*9999 no beat'},
{108, '*4 200% distant'},
{109, '*2.5 no distant'},
--
{110, '*99 9000% beat'},
{110.25, '*9999 no beat'},
{112, '*4 200% hallway'},
{113, '*2.5 no hallway'},
{114, '*99 -9000% beat'},
{114.25, '*9999 no beat'},
{116, '*9 500% drunk'},
{116.5, '*18 no drunk'},
{117, '*9 -500% drunk'},
{117.5, '*18 no drunk'},
{118, '*99 9000% beat'},
{118.25, '*9999 no beat'},
{120, '-50% flip'},
{121, 'no flip'},
{122, '*99 -9000% beat'},
{122.25, '*9999 no beat'},
{124, 'flip'},
{125, 'no flip'},
{126, '*99 9000% beat'},
{126.25, '*9999 no beat'},
{128, '*4 flip'},
{128.5, '*4 no flip'},
{129, '*4 flip'},
{130, '*99 -9000% beat'},
{130.25, '*9999 no beat,*99 no flip'},
--
{132, '*4 200% space'},
{133, '*2.5 no space'},
{134, '*99 -9000% beat'},
{134.25, '*9999 no beat'},
{136, '*4 200% incoming'},
{137, '*2.5 no incoming'},
{138, '*99 9000% beat'},
{138.25, '*9999 no beat'},
{140, '*4 flip,*4 -100% invert'},
{140.5, '*4 no invert'},
{141, '*4 no flip,*4 invert'},
{141.5, '*4 no invert'},
{142, '*99 -9000% beat'},
{142.25, '*9999 no beat'},
{144, '*4 tornado'},
{145, '*2.5 no tornado'},
{146, '*99 9000% beat'},
{146.25, '*9999 no beat'},
{148, '*9 500% tipsy'},
{148.5, '*18 no tipsy'},
{149, '*9 -500% tipsy'},
{149.5, '*18 no tipsy'},
{150, '*99 -9000% beat'},
{150.25, '*9999 no beat'},
{152, '*4 invert'},
{153, '*4 no invert,*4 flip'},
{153.5, '*4 no flip'},
{154, '*99 9000% beat'},
{154.5, '*9999 no beat'},
{155, '*9 500% tipsy'},
{155.5, '*18 no tipsy'},
{156, '*9 500% drunk,*9 -500% tipsy'},
{156.5, '*18 no drunk,*18 no tipsy'},
{157, '*9 -500% drunk,*9 500% tipsy'},
{157.5, '*18 no drunk,*18 no tipsy'},
{158, '*99 -9000% beat'},
{158.25, '*9999 no beat'},
--
{191, '*8 400% centered'},
{192, '*99 no centered,3.75x,*99 10% tiny'},
{192.25, '*99 20% tiny'},
{192.5, '*99 30% tiny'},
{192.75, '*99 40% tiny'},
{193, '*99 50% tiny'},
{193.25, '*99 60% tiny'},
{193.5, '*99 70% tiny'},
{193.75, '*99 80% tiny'},
{194, '*99 75% tiny'},
{194.25, '*99 65% tiny'},
{194.5, '*99 55% tiny'},
{194.75, '*99 45% tiny'},
{195, '*99 35% tiny'},
{195.25, '*99 25% tiny'},
{195.5, '*99 15% tiny'},
{195.75, '*99 no tiny'},
{196, '*99 10% tiny'},
{196.25, '*99 20% tiny'},
{196.5, '*99 30% tiny'},
{196.75, '*99 40% tiny'},
{197, '*99 50% tiny'},
{197.25, '*99 60% tiny'},
{197.5, '*99 70% tiny'},
{197.75, '*99 80% tiny'},
{198, '*99 75% tiny'},
{198.25, '*99 65% tiny'},
{198.5, '*99 55% tiny'},
{198.75, '*99 45% tiny'},
{199, '*99 35% tiny'},
{199.25, '*99 25% tiny'},
{199.5, '*99 15% tiny'},
{199.75, '*99 no tiny'},
{200, '*99 10% tiny'},
{200.25, '*99 20% tiny'},
{200.5, '*99 30% tiny'},
{200.75, '*99 40% tiny'},
{201, '*99 50% tiny'},
{201.25, '*99 60% tiny'},
{201.5, '*99 70% tiny'},
{201.75, '*99 80% tiny'},
{202, '*99 75% tiny'},
{202.25, '*99 65% tiny'},
{202.5, '*99 55% tiny'},
{202.75, '*99 45% tiny'},
{203, '*99 35% tiny'},
{203.25, '*99 25% tiny'},
{203.5, '*99 15% tiny'},
{203.75, '*99 no tiny'},
{204, '*99 10% tiny'},
{204.25, '*99 20% tiny'},
{204.5, '*99 30% tiny'},
{204.75, '*99 40% tiny'},
{205, '*99 50% tiny'},
{205.25, '*99 60% tiny'},
{205.5, '*99 70% tiny'},
{205.75, '*99 80% tiny'},
{206, '*99 75% tiny'},
{206.25, '*99 65% tiny'},
{206.5, '*99 55% tiny'},
{206.75, '*99 45% tiny'},
{207, '*99 35% tiny'},
{207.25, '*99 25% tiny'},
{207.5, '*99 15% tiny'},
{207.75, '*99 no tiny'},
--
{208, '*99 10% tiny,550% bumpy'},
{208.25, '*99 20% tiny'},
{208.5, '*99 30% tiny'},
{208.75, '*99 40% tiny'},
{209, '*99 50% tiny'},
{209.25, '*99 60% tiny'},
{209.5, '*99 70% tiny'},
{209.75, '*99 80% tiny'},
{210, '*99 75% tiny'},
{210.25, '*99 65% tiny'},
{210.5, '*99 55% tiny'},
{210.75, '*99 45% tiny'},
{211, '*99 35% tiny'},
{211.25, '*99 25% tiny'},
{211.5, '*99 15% tiny'},
{211.75, '*99 no tiny'},
{212, '*4 200% mini'},
{212.25, '*4 no mini'},
{212.5, '*8 200% mini'},
{212.75, '*8 no mini'},
{213, '*8 200% mini'},
{213.25, '*8 no mini'},
{213.5, '*8 200% mini'},
{213.75, '*8 no mini'},
{214, '*8 200% mini'},
{214.25, '*8 no mini'},
{214.5, '*8 200% mini'},
{214.75, '*8 no mini'},
{215, '*8 200% mini'},
{215.25, '*8 no mini'},
{215.5, '*8 200% mini'},
{215.75, '*8 no mini'},
{216, '*12 200% mini'},
{216.25, '*12 no mini'},
{216.5, '*12 200% mini'},
{216.75, '*12 no mini'},
{217, '*12 200% mini'},
{217.25, '*12 no mini'},
{217.5, '*12 200% mini'},
{217.75, '*12 no mini'},
{218, '*12 200% mini'},
{218.25, '*12 no mini'},
{218.5, '*12 200% mini'},
{218.75, '*12 no mini'},
{219, '*12 200% mini'},
{219.25, '*12 no mini'},
{219.5, '*12 200% mini'},
{219.75, '*12 no mini'},
{220, '*12 200% mini'},
{220.25, '*12 no mini'},
{220.5, '*12 200% mini'},
{220.75, '*12 no mini'},
{221, '*12 200% mini'},
{221.25, '*12 no mini'},
{221.5, '*12 200% mini'},
{221.75, '*12 no mini'},
{222, '*12 200% mini'},
{222.25, '*12 no mini'},
{222.5, '*12 200% mini'},
{222.75, '*12 no mini'},
{223, '*12 200% mini'},
{223.25, '*12 no mini'},
{223.5, '*12 200% mini'},
{223.75, '*99 no mini'},
{224, '*99 flip,*99 3x,*99 no bumpy'},
{230, '*2.5 no flip'},
{230.5, '*4 200% space,*6 250% bumpy'},
{231.5, '*4 no space,*6 no bumpy'},
{232, '*100 500% drunk, *100 500% tipsy'},
{232.25, '*8 no drunk, *8 no tipsy'},
{234, '*100 -500% drunk, *100 -500% tipsy'},
{234.25, '*8 no drunk, *8 no tipsy'},
{236, '*100 500% drunk, *100 500% tipsy'},
{236.25, '*8 no drunk, *8 no tipsy'},
{238, '*100 -500% drunk, *100 -500% tipsy'},
{238.25, '*8 no drunk, *8 no tipsy'},
{240, '*100 500% drunk, *100 500% tipsy'},
{240.25, '*8 no drunk, *8 no tipsy'},
{242, '*100 -500% drunk, *100 -500% tipsy'},
{242.25, '*8 no drunk, *8 no tipsy'},
{244, '*100 500% drunk, *100 500% tipsy'},
{244.25, '*8 no drunk, *8 no tipsy'},
{246, '*100 -500% drunk, *100 -500% tipsy'},
{246.25, '*8 no drunk, *8 no tipsy'},
{248, '*100 500% drunk, *100 500% tipsy'},
{248.25, '*8 no drunk, *8 no tipsy'},
{250, '*100 -500% drunk, *100 -500% tipsy'},
{250.25, '*8 no drunk, *8 no tipsy'},
{252, '*100 500% drunk, *100 500% tipsy'},
{252.25, '*8 no drunk, *8 no tipsy'},
--
{254, '*8 reverse'},
{254.333, '*8 no reverse'},
{254.667, '*8 reverse'},
{255, '*8 no reverse'},
{255.333, '*8 reverse'},
{255.667, '*8 no reverse'},
{256, '*100 -500% drunk, *100 -500% tipsy'},
{256.25, '*8 no drunk, *8 no tipsy'},
{258, '*99 9000% beat'},
{258.25, '*9999 no beat,*99 dark,*99 reverse'},
--
{260, '*99 no dark,*100 500% drunk, *100 500% tipsy'},
{260.25, '*8 no drunk, *8 no tipsy'},
{262, '*100 -500% drunk, *100 -500% tipsy'},
{262.25, '*8 no drunk, *8 no tipsy'},
{264, '*100 500% drunk, *100 500% tipsy'},
{264.25, '*8 no drunk, *8 no tipsy'},
{266, '*100 -500% drunk, *100 -500% tipsy'},
{266.25, '*8 no drunk, *8 no tipsy'},
{268, '*100 500% drunk, *100 500% tipsy'},
{268.25, '*8 no drunk, *8 no tipsy'},
{270, '*100 -500% drunk, *100 -500% tipsy'},
{270.25, '*8 no drunk, *8 no tipsy'},
{272, '*100 500% drunk, *100 500% tipsy'},
{272.25, '*8 no drunk, *8 no tipsy'},
{274, '*100 -500% drunk, *100 -500% tipsy'},
{274.25, '*8 no drunk, *8 no tipsy'},
{276, '*100 500% drunk, *100 500% tipsy'},
{276.25, '*8 no drunk, *8 no tipsy'},
{278, '*100 -500% drunk, *100 -500% tipsy'},
{278.25, '*8 no drunk, *8 no tipsy'},
{280, '*100 500% drunk, *100 500% tipsy'},
{280.25, '*8 no drunk, *8 no tipsy'},
{282, '*100 -500% drunk, *100 -500% tipsy'},
{282.25, '*8 no drunk, *8 no tipsy'},
{284, '*100 500% drunk, *100 500% tipsy'},
{284.25, '*8 no drunk, *8 no tipsy'},
{286, '*100 -500% drunk, *100 -500% tipsy'},
{286.25, '*8 no drunk, *8 no tipsy'},
{288, '*100 500% drunk, *100 500% tipsy'},
{288.25, '*8 no drunk, *8 no tipsy'},
{290, '*99 -9000% beat'},
{290.25, '*9999 no beat,*99 dark,*99 no reverse'},
--
{292, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{292.25, '*8 no drunk, *8 no tipsy'},
{294, '*100 500% drunk, *100 500% tipsy'},
{294.25, '*8 no drunk, *8 no tipsy'},
{296, '*100 -500% drunk, *100 -500% tipsy'},
{296.25, '*8 no drunk, *8 no tipsy'},
{296, '*100 500% drunk, *100 500% tipsy'},
{296.25, '*8 no drunk, *8 no tipsy'},
{298, '*4 200% incoming,*6 250% bumpy'},
{299, '*4 no incoming,*6 no bumpy'},
{300, '*100 -500% drunk, *100 -500% tipsy'},
{300.25, '*8 no drunk, *8 no tipsy'},
{302, '*100 500% drunk, *100 500% tipsy'},
{302.25, '*8 no drunk, *8 no tipsy'},
{304, '*100 -500% drunk, *100 -500% tipsy'},
{304.25, '*8 no drunk, *8 no tipsy'},
{306, '*99 9000% beat'},
{306.25, '*9999 no beat,*99 dark,*99 reverse'},
{308, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{308.25, '*8 no drunk,*8 no tipsy'},
{310, '*100 -500% drunk,*100 -500% tipsy'},
{310.25, '*8 no drunk,*8 no tipsy'},
{312, '*100 500% drunk,*100 500% tipsy'},
{312.25, '*8 no drunk,*8 no tipsy'},
{314, '*99 -9000% beat'},
{314.25, '*9999 no beat,*99 dark,*99 no reverse'},
{316, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{316.25, '*8 no drunk,*8 no tipsy'},
{318, '*100 500% drunk,*100 500% tipsy'},
{318.25, '*8 no drunk,*8 no tipsy'},
{320, '*100 -500% drunk,*100 -500% tipsy'},
{320.25, '*8 no drunk,*8 no tipsy'},
{322, '*99 9000% beat'},
{322.25, '*9999 no beat,*99 dark,*99 reverse'},
{324, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{324.25, '*8 no drunk,*8 no tipsy'},
{326, '*100 -500% drunk,*100 -500% tipsy'},
{326.25, '*8 no drunk,*8 no tipsy'},
{328, '*100 500% drunk,*100 500% tipsy'},
{328.25, '*8 no drunk,*8 no tipsy'},
{330, '*4 200% distant,*6 250% bumpy'},
{331, '*4 no distant,*6 no bumpy'},
{332, '*100 -500% drunk,*100 -500% tipsy'},
{332.25, '*8 no drunk,*8 no tipsy'},
{334, '*100 500% drunk,*100 500% tipsy'},
{334.25, '*8 no drunk,*8 no tipsy'},
{336, '*100 -500% drunk,*100 -500% tipsy'},
{336.25, '*8 no drunk,*8 no tipsy'},
{338, '*99 -9000% beat'},
{338.25, '*9999 no beat,*99 dark,*99 no reverse'},
{340, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{340.25, '*8 no drunk,*8 no tipsy'},
{342, '*100 -500% drunk,*100 -500% tipsy'},
{342.25, '*8 no drunk,*8 no tipsy'},
{344, '*100 500% drunk,*100 500% tipsy'},
{344.25, '*8 no drunk,*8 no tipsy'},
{346, '*99 9000% beat'},
{346.25, '*9999 no beat,*99 dark,*99 reverse'},
{348, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{348.25, '*8 no drunk,*8 no tipsy'},
{350, '*100 500% drunk,*100 500% tipsy'},
{350.25, '*8 no drunk,*8 no tipsy'},
{352, '*100 -500% drunk,*100 -500% tipsy'},
{352.25, '*8 no drunk,*8 no tipsy'},
{354, '*99 -9000% beat'},
{354.25, '*9999 no beat,*99 dark,*99 no reverse'},
{356, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{356.25, '*8 no drunk,*8 no tipsy'},
{358, '*100 -500% drunk,*100 -500% tipsy'},
{358.25, '*8 no drunk,*8 no tipsy'},
--360 NOSCOPED! (lol, how many times do i have to type this lmao)
{360, '*99 9000% beat'},
{360.25, '*9999 no beat,*99 dark,*99 tornado,*99 55% stealth,*99 blind'},
{424, '*4 no tornado,*4 no stealth'},
{492, '*99 no blind,*99 no dark,*100 500% drunk,*100 500% tipsy'},
{492.25, '*8 no drunk,*8 no tipsy'},
{494, '*100 -500% drunk,*100 -500% tipsy'},
{494.25, '*8 no drunk,*8 no tipsy'},
{496, '*100 500% drunk,*100 500% tipsy'},
{496.25, '*8 no drunk,*8 no tipsy'},
{498, '*100 -500% drunk,*100 -500% tipsy'},
{498.5, '*8 no drunk,*8 no tipsy,*4 200% hallway,*6 250% bumpy,-50% flip'},
{499.5, '*4 no hallway,*6 no bumpy,no flip'},
{500, '*100 500% drunk,*100 500% tipsy'},
{500.25, '*8 no drunk,*8 no tipsy'},
{502, '*100 -500% drunk,*100 -500% tipsy'},
{502.25, '*8 no drunk,*8 no tipsy'},
{504, '*100 500% drunk,*100 500% tipsy'},
{504.25, '*8 no drunk,*8 no tipsy'},
{506, '*100 -500% drunk,*100 -500% tipsy'},
{506.25, '*8 no drunk,*8 no tipsy'},
{508, '*100 500% drunk,*100 500% tipsy'},
{508.25, '*8 no drunk,*8 no tipsy'},
{510, '*100 -500% drunk,*100 -500% tipsy'},
{510.25, '*8 no drunk,*8 no tipsy'},
{512, '*100 500% drunk,*100 500% tipsy'},
{512.25, '*8 no drunk,*8 no tipsy'},
{514, '*100 -500% drunk,*100 -500% tipsy'},
{514.25, '*8 no drunk,*8 no tipsy'},
{516, '*100 500% drunk,*100 500% tipsy'},
{516.25, '*8 no drunk,*8 no tipsy'},
{518, '*99 -9000% beat'},
{518.25, '*9999 no beat,*99 dark,*99 reverse'},
{520, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{520.25, '*8 no drunk,*8 no tipsy'},
{522, '*100 500% drunk,*100 500% tipsy'},
{522.25, '*8 no drunk,*8 no tipsy'},
{524, '*100 -500% drunk,*100 -500% tipsy'},
{524.25, '*8 no drunk,*8 no tipsy'},
{526, '*100 500% drunk,*100 500% tipsy'},
{526.25, '*8 no drunk,*8 no tipsy'},
{528, '*100 -500% drunk,*100 -500% tipsy'},
{528.25, '*8 no drunk,*8 no tipsy'},
{530, '*100 500% drunk,*100 500% tipsy'},
{530.25, '*8 no drunk,*8 no tipsy'},
{532, '*100 -500% drunk,*100 -500% tipsy'},
{532.25, '*8 no drunk,*8 no tipsy'},
{534, '*100 500% drunk,*100 500% tipsy'},
{534.25, '*8 no drunk,*8 no tipsy'},
{536, '*100 -500% drunk,*100 -500% tipsy'},
{536.25, '*8 no drunk,*8 no tipsy'},
{538, '*100 500% drunk,*100 500% tipsy'},
{538.25, '*8 no drunk,*8 no tipsy'},
{540, '*100 500% drunk,*100 500% tipsy'},
{540.25, '*8 no drunk,*8 no tipsy'},
{542, '*100 -500% drunk,*100 -500% tipsy'},
{542.25, '*8 no drunk,*8 no tipsy'},
{544, '*100 500% drunk,*100 500% tipsy'},
{544.25, '*8 no drunk,*8 no tipsy'},
{546, '*100 -500% drunk,*100 -500% tipsy'},
{546.25, '*8 no drunk,*8 no tipsy'},
{548, '*100 500% drunk,*100 500% tipsy'},
{548.25, '*8 no drunk,*8 no tipsy'},
{550, '*99 9000% beat'},
{550.25, '*9999 no beat,*99 dark'},
{552, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{552.25, '*8 no drunk,*8 no tipsy'},
{554, '*100 500% drunk,*100 500% tipsy'},
{554.25, '*8 no drunk,*8 no tipsy'},
{556, '*100 -500% drunk,*100 -500% tipsy'},
{556.25, '*8 no drunk,*8 no tipsy'},
{558, '*100 500% drunk,*100 500% tipsy'},
{558.5, '*8 no drunk,*8 no tipsy,*4 200% space,*6 250% bumpy,*2 -75% flip'},
{559.5, '*4 no space,*6 no bumpy,*2 no flip'},
{560, '*100 -500% drunk,*100 -500% tipsy'},
{560.25, '*8 no drunk,*8 no tipsy'},
{562, '*100 500% drunk,*100 500% tipsy'},
{562.25, '*8 no drunk,*8 no tipsy'},
{564, '*100 -500% drunk,*100 -500% tipsy'},
{564.25, '*8 no drunk,*8 no tipsy'},
{566, '*99 -9000% beat'},
{566.25, '*9999 no beat,*99 dark,*99 no reverse'},
{568, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{568.25, '*8 no drunk,*8 no tipsy'},
{570, '*100 -500% drunk,*100 -500% tipsy'},
{570.25, '*8 no drunk,*8 no tipsy'},
{572, '*100 500% drunk,*100 500% tipsy'},
{572.25, '*8 no drunk,*8 no tipsy'},
{574, '*99 9000% beat'},
{574.25, '*9999 no beat,*99 dark'},
{576, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{576.25, '*8 no drunk,*8 no tipsy'},
{578, '*100 500% drunk,*100 500% tipsy'},
{578.25, '*8 no drunk,*8 no tipsy'},
{580, '*100 -500% drunk,*100 -500% tipsy'},
{580.25, '*8 no drunk,*8 no tipsy'},
{582, '*99 -9000% beat'},
{582.25, '*9999 no beat,*99 dark'},
{584, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{584.25, '*8 no drunk,*8 no tipsy'},
{586, '*100 -500% drunk,*100 -500% tipsy'},
{586.25, '*8 no drunk,*8 no tipsy'},
{588, '*100 500% drunk,*100 500% tipsy'},
{588.25, '*8 no drunk,*8 no tipsy'},
{590, '*100 -500% drunk,*100 -500% tipsy'},
{590.5, '*8 no drunk,*8 no tipsy,*4 200% incoming,*6 250% bumpy,*2 -80% flip'},
{591.5, '*4 no incoming,*6 no bumpy,*2 no flip'},
{592, '*100 500% drunk,*100 500% tipsy'},
{592.25, '*8 no drunk,*8 no tipsy'},
{594, '*100 -500% drunk,*100 -500% tipsy'},
{594.25, '*8 no drunk,*8 no tipsy'},
{596, '*100 500% drunk,*100 500% tipsy'},
{596.25, '*8 no drunk,*8 no tipsy'},
{598, '*99 9000% beat'},
{598.25, '*9999 no beat,*99 dark'},
--
{600, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{600.25, '*8 no drunk,*8 no tipsy'},
{602, '*100 500% drunk,*100 500% tipsy'},
{602.25, '*8 no drunk,*8 no tipsy'},
{604, '*100 -500% drunk,*100 -500% tipsy'},
{604.25, '*8 no drunk,*8 no tipsy'},
{606, '*99 -9000% beat'},
{606.25, '*9999 no beat,*99 dark'},
{608, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{608.25, '*8 no drunk,*8 no tipsy'},
{610, '*100 -500% drunk,*100 -500% tipsy'},
{610.25, '*8 no drunk,*8 no tipsy'},
{612, '*100 500% drunk,*100 500% tipsy'},
{612.25, '*8 no drunk,*8 no tipsy'},
{614, '*99 9000% beat'},
{614.25, '*9999 no beat,*99 dark'},
{616, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{616.25, '*8 no drunk,*8 no tipsy'},
{618, '*100 500% drunk,*100 500% tipsy'},
{618.25, '*8 no drunk,*8 no tipsy'},
{620, '*100 -500% drunk,*100 -500% tipsy'},
{620.25, '*8 no drunk,*8 no tipsy'},
{622, '*100 500% drunk,*100 500% tipsy'},
{622.5, '*8 no drunk,*8 no tipsy,*4 200% space,*6 250% bumpy,*2 -85% flip'},
{623.5, '*4 no space,*6 no bumpy,*2 no flip'},
{624, '*100 -500% drunk,*100 -500% tipsy'},
{624.25, '*8 no drunk,*8 no tipsy'},
{626, '*100 500% drunk,*100 500% tipsy'},
{626.25, '*8 no drunk,*8 no tipsy'},
{628, '*100 -500% drunk,*100 -500% tipsy'},
{628.25, '*8 no drunk,*8 no tipsy'},
{630, '*99 -9000% beat'},
{630.25, '*9999 no beat,*99 dark,*99 reverse'},
{632, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{632.25, '*8 no drunk,*8 no tipsy'},
{634, '*100 -500% drunk,*100 -500% tipsy'},
{634.25, '*8 no drunk,*8 no tipsy'},
{636, '*100 500% drunk,*100 500% tipsy'},
{636.25, '*8 no drunk,*8 no tipsy'},
{638, '*99 9000% beat'},
{638.25, '*9999 no beat,*99 dark'},
{640, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{640.25, '*8 no drunk,*8 no tipsy'},
{642, '*100 500% drunk,*100 500% tipsy'},
{642.25, '*8 no drunk,*8 no tipsy'},
{644, '*100 -500% drunk,*100 -500% tipsy'},
{644.25, '*8 no drunk,*8 no tipsy'},
{646, '*99 -9000% beat'},
{646.25, '*9999 no beat,*99 dark'},
{648, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{648.25, '*8 no drunk,*8 no tipsy'},
{650, '*100 -500% drunk,*100 -500% tipsy'},
{650.25, '*8 no drunk,*8 no tipsy'},
{652, '*100 500% drunk,*100 500% tipsy'},
{652.25, '*8 no drunk,*8 no tipsy'},
{654, '*100 -500% drunk,*100 -500% tipsy'},
{654.5, '*8 no drunk,*8 no tipsy,*4 200% distant,*6 250% bumpy,*2 -90% flip'},
{655.5, '*4 no distant,*6 no bumpy,*2 no flip'},
{656, '*100 500% drunk,*100 500% tipsy'},
{656.25, '*8 no drunk,*8 no tipsy'},
{658, '*100 -500% drunk,*100 -500% tipsy'},
{658.25, '*8 no drunk,*8 no tipsy'},
{660, '*100 500% drunk,*100 500% tipsy'},
{660.25, '*8 no drunk,*8 no tipsy'},
{662, '*99 9000% beat'},
{662.25, '*9999 no beat,*99 dark'},
{664, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{664.25, '*8 no drunk,*8 no tipsy'},
--lol, didnt know this song can summon satan.
{666, '*100 500% drunk,*100 500% tipsy'},
{666.25, '*8 no drunk,*8 no tipsy'},
{668, '*100 -500% drunk,*100 -500% tipsy'},
{668.25, '*8 no drunk,*8 no tipsy'},
{670, '*99 -9000% beat'},
{670.25, '*9999 no beat,*99 dark,*99 reverse'},
{672, '*99 no dark,*100 500% drunk,*100 500% tipsy'},
{672.25, '*8 no drunk,*8 no tipsy'},
{674, '*100 -500% drunk,*100 -500% tipsy'},
{674.25, '*8 no drunk,*8 no tipsy'},
{676, '*100 500% drunk,*100 500% tipsy'},
{676.25, '*8 no drunk,*8 no tipsy'},
{678, '*99 9000% beat'},
{678.25, '*9999 no beat,*99 dark,*99 no reverse'},
{680, '*99 no dark,*100 -500% drunk,*100 -500% tipsy'},
{680.25, '*8 no drunk,*8 no tipsy'},
{682, '*100 500% drunk,*100 500% tipsy'},
{682.25, '*8 no drunk,*8 no tipsy'},
{685, '*999 50% mini'},
{687, '*999 mini'},
{689, '*999 150% mini'},
{691, '*999 200% mini,*99 blind'}
--End.



}

local s = chara;
--sprite stuff
curaction = 1;
--{beat,action,persist}
actions = {
	
	
	
	
}


curaction = 1;
--{beat,action,persist}
actions = {
	{1,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{3,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{5,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{7,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{9,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{11,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{13,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{15,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{17,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{19,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{21,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{23,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{25,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{27,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{29,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{31,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{32,function()
		if P1 then P1:spin():effectmagnitude(0, 0, -20):effectclock('beat'):effectperiod(16) end
		if P2 then P2:spin():effectmagnitude(0, 0, 20):effectclock('beat'):effectperiod(16) end
	end},
	{40,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{41,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{43,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{45,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{47,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{48,function()
		if P1 then P1:spin():effectmagnitude(0, 0, -20):effectclock('beat'):effectperiod(16) end
		if P2 then P2:spin():effectmagnitude(0, 0, 20):effectclock('beat'):effectperiod(16) end
	end},
	{56,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{57,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{59,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{61,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{63,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{64,function()
		if P1 then P1:spin():effectmagnitude(0, 0, -20):effectclock('beat'):effectperiod(16) end
		if P2 then P2:spin():effectmagnitude(0, 0, 20):effectclock('beat'):effectperiod(16) end
	end},
	{72,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{73,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{75,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{77,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{79,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{80,function()
		if P1 then P1:spin():effectmagnitude(0, 0, -20):effectclock('beat'):effectperiod(16) end
		if P2 then P2:spin():effectmagnitude(0, 0, 20):effectclock('beat'):effectperiod(16) end
	end},
	{88,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{89,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{91,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{93,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{95,function()
		if P1 then P1:smooth(0.10):spring(0.3):addrotationz(-20):accelerate(0.10) end
		if P2 then P2:smooth(0.10):spring(0.3):addrotationz(20):accelerate(0.10) end
	end},
	{96,function()
		if P1 then P1:smooth(1):rotationz(0):accelerate(0.10) end
		if P2 then P2:smooth(1):rotationz(0):accelerate(0.10) end
	end},
	{96.1,function()
		if P1 then P1:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(10) end
		if P2 then P2:wag():effectmagnitude(0, 0, -15):effectclock('beat'):effectperiod(10) end
	end},
	{160,function()
		if P1 then P1:wag():effectmagnitude(20, 20, 20):effectclock('beat'):effectperiod(10) end
		if P2 then P2:wag():effectmagnitude(-20, -20, -20):effectclock('beat'):effectperiod(10) end
	end},
	{192,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{232.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{234,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{234.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{236,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{236.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{238,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{238.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{240,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{240.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{242,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{242.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{244,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{244.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{246,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{246.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{248,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{248.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{250,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{250.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{252,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{252.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{254,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{256.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{258,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{260.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{262,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{262.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{264,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{264.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{266,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{266.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{268,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{268.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{270,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{270.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{272,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{272.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{274,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{274.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{276,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{276.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{278,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{278.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{280,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{280.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{282,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{282.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{284,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{284.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{286,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{286.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{288,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{288.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{290,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{292.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{294,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{294.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{296,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{296.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{298,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{300,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{300.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{302,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{302.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{304,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{304.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{306,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{308.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{310,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{310.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{312,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{312.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{314,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{316.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{318,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{318.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{320,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{320.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{322,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{324.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{326,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{326.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{328,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{328.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{330,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{332.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{334,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{334.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{336,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{336.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{338,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{340.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{342,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{342.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{344,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{344.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{346,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{348.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{350,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{350.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{352,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{352.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{354,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{356.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{358,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{358.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	--360 NOSCOPED! (i rly need to make a counter of how many times i type this lol)
	{360,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{492.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{494,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{494.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{496,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{496.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{498,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{500.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{502,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{502.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{504,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{504.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{506,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{506.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{508,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{508.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{510,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{510.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{512,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{512.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{514,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{514.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{516,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{516.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{518,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{520.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{522,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{522.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{524,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{524.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{526,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{526.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{528,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{528.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{530,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{530.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{532,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{532.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{534,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{534.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{536,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{536.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{538,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{538.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{540,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{540.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{542,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{542.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{544,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{544.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{546,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{546.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{548,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{548.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{550,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{552.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{554,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{554.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{556,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{556.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{558,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{560.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{562,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{562.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{564,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{564.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{566,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{568.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{570,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{570.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{572,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{572.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{574,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{576.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{578,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{578.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{580,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{580.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{582,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{584.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{586,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{586.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{588,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{588.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{590,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{592.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{594,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{594.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{596,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{596.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{598,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{600.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{602,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{602.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{604,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{604.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{606,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{608.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{610,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{610.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{612,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{612.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{614,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{616.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{618,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{618.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{620,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{620.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{622,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{624.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{626,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{626.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{628,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{628.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{630,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{632.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{634,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{634.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{636,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{636.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{638,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{640.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{642,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{642.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{644,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{644.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{646,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{648.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{650,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{650.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{652,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{652.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{654,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{656.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{658,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{658.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{660,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{660.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{662,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{664.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	--(more satan-ness)
	{666,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{666.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{668,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{668.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{670,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{672.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{674,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{674.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{676,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{676.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{678,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{680.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{682,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end},
	{682.5,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:vibrate()
					tiles2d[j][i]:effectmagnitude(15,15,15)
					tiles2d[j][i]:effectclock('bgm')
				end
			end
		end
	end},
	{684,function()
		for j=1,table.getn(tiles2d) do
			for i=1,table.getn(tiles2d[j]) do
				if j%2 == 0 and i%2 == 1 or j%2 == 1 and i%2 == 0 then
					tiles2d[j][i]:stopeffect()
				end
			end
		end
	end}




}

--SCREAMING GUMBALL
curmessage = 1;
--{beat,message,{params},persist?}
messages = {
}


	function modtable_compare(a,b)
		return a[1] < b[1]
	end
	
	if table.getn(mods) > 1 then
		table.sort(mods, modtable_compare)
	end
	
	if table.getn(messages) > 1 then
		table.sort(messages, modtable_compare)
	end
	
	if table.getn(actions) > 1 then
		table.sort(actions, modtable_compare)
	end
	
	if table.getn(actions) > 1 then
		table.sort(actions, modtable_compare)
	end
	
end

local function update(self, delta)

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
		
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
		
		if SCREENMAN:GetTopScreen():GetChild('ScoreP1') then
			SCREENMAN:GetTopScreen():GetChild('ScoreP1'):visible(false)
		end
		if SCREENMAN:GetTopScreen():GetChild('ScoreP2') then
			SCREENMAN:GetTopScreen():GetChild('ScoreP2'):visible(false)
		end
		
		if SCREENMAN:GetTopScreen():GetChild('Debug') then
			SCREENMAN:GetTopScreen():GetChild('Debug'):y(SCREEN_CENTER_Y-60)
		end

		screen = SCREENMAN:GetTopScreen();
		screen:SetDrawByZPosition(true);
		
		if SCREENMAN:GetTopScreen():GetChild('SongForeground') then
			SCREENMAN:GetTopScreen():GetChild('SongForeground'):z(2)
		end
		
		if P1 then P1:z(1) end
		if P2 then P2:z(1) end
		
		checked = true;
		
	end
	
	local beat = GAMESTATE:GetSongBeat()
	
	local spd = 6;
			
	if beat>304 then spd = 12 end
	
	
	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		mod(total_mod_str)
	end
	
	if beat>7 and fgcurcommand==0 then
		if P1 then P1:linear(0.1) P1:x(SCREEN_WIDTH*0.25) end
		if P2 then P2:linear(0.1) P2:x(SCREEN_WIDTH*0.75) end
		fgcurcommand = fgcurcommand+1;
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		if table.getn(mods[curmod]) < 3 then
			add_mod(mods[curmod][2])
		else
			mod_internal(mods[curmod][2], 'PlayerNumber_P' .. mods[curmod][3])
		end
		curmod = curmod+1
	end

	execute_mods()
	
	
	
	
	
	
	--SCREAMING GUMBALL
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][4] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2],messages[curmessage][3])
			curmessage = curmessage+1;
		end
	end
	
	while curaction<= #actions and GAMESTATE:GetSongBeat()>=actions[curaction][1] do
		if actions[curaction][3] and GAMESTATE:GetSongBeat()>=actions[curaction][1]+5 then
			curaction = curaction+1;
		else
			actions[curaction][2]()
			curaction = curaction+1;
		end
	end
	
	while curaction<= #actions and GAMESTATE:GetSongBeat()>=actions[curaction][1] do
		if actions[curaction][3] or GAMESTATE:GetSongBeat() < actions[curaction][1]+2 then
			actions[curaction][2]()
		end
		curaction = curaction+1;
	end
	
end

local t = Def.ActorFrame{
	OnCommand= function(self)
							 init()
							 self:SetUpdateFunction(update)
							 self:fov(90);
						 end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Quad{
		InitCommand=function(self) vibquad = self end,
		OnCommand= cmd(x,0),
	},
	
}

t[#t+1] = Def.Quad{
	OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,1),
}

t[#t+1] = Def.ActorFrameTexture{
	Name = "ScreenTex";
	InitCommand=function(self)
		self:SetTextureName( "ScreenTex" )
		self:SetWidth(sw);
		self:SetHeight(sh);
		self:EnableAlphaBuffer(true);
		self:Create();
	end;
	OnCommand=function(self)
		self:visible(true);
		self:Draw();
	end;
	Def.Quad{ OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,1), },
	LoadActor("../BG.png")..{
		OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT),
	},
	Def.ActorProxy{ Name = "ProxyUL"; OnCommand=function(self) self:x(0); self:y(0) self:SetTarget(SCREENMAN:GetTopScreen():GetChild('Underlay')); end },
	Def.ActorProxy{ Name = "ProxyP1"; OnCommand=function(self) self:x(0); self:y(0)
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'));
		else
			self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'));
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):x(SCREEN_WIDTH*0.25);
			self:addx(SCREEN_WIDTH*0.5);
		end
	end },
	Def.ActorProxy{ Name = "ProxyP2"; OnCommand=function(self) self:x(0); self:y(0)
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'));
		else
			self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'));
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):x(SCREEN_WIDTH*0.25);
			self:addx(SCREEN_WIDTH*0.5);
		end
	end },
	Def.ActorProxy{ Name = "ProxyOL"; OnCommand=function(self) self:x(0); self:y(0) self:SetTarget(SCREENMAN:GetTopScreen():GetChild('Overlay')); end },
};

for j = 0,vstrips-1 do
	tiles2d[j+1] = {}
	for i = 0,hstrips-1 do
		t[#t+1] = Def.Sprite{
			Name = "ScreenCopyx"..i.."y"..j;
			Texture = "ScreenTex";
			InitCommand=function(self)
				table.insert(tiles,self);
				table.insert(tiles2d[j+1],self);
				table.insert(tileObjects,{OrigX=(sw*((i+0.5)/hstrips)),OrigY=(sh*((j+0.5)/vstrips))});
			end,
			OnCommand=function(self)
				self:x(sw*((i+0.5)/hstrips));
				self:y(sh*((j+0.5)/vstrips));
				self:cropleft(i/hstrips)
				self:cropright(((hstrips-1)-i)/hstrips)
				self:croptop(j/vstrips)
				self:cropbottom(((vstrips-1)-j)/vstrips)
				self:align((i+0.5)/hstrips,(j+0.5)/vstrips)
			end,
		};
	end
end


t[#t+1] = Def.Quad{
	OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,0),
	WhiteFlashMessageCommand=cmd(finishtweening;diffuse,1,1,1,1;linear,0.6;diffusealpha,0),
	WhiteFlashLongMessageCommand=cmd(finishtweening;diffuse,1,1,1,1;linear,2;diffusealpha,0),
	RedFlashQMessageCommand=cmd(finishtweening;diffuse,1,0,0,0.6;linear,0.6;diffusealpha,0),
	RedFlashMessageCommand=cmd(finishtweening;diffuse,1,0,0,1;linear,1;diffusealpha,0),
}

return t